import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

@SuppressWarnings("serial")
public class ImageViewer extends Frame{
	private Image image;
	private int imgWidth, imgHeight;
	
	ImageViewer(){
		setImage();
		setSize(imgWidth, imgHeight);
		setTitle("ÏXO");
		setVisible(true);
		addWindowListener(new ExitWindow());
	}
	private void setImage(){
		image = Toolkit.getDefaultToolkit().getImage("simazu.jpg");
		MediaTracker mt = new MediaTracker(this);
		mt.addImage(image, 0);
		try{
			mt.waitForID(0);
		}catch(InterruptedException ex){
			throw new IllegalArgumentException("O");
		}
		imgWidth = image.getWidth(this);
		imgHeight = image.getHeight(this);
	}
	public static void main(String[] args){
		@SuppressWarnings("unused")
		ImageViewer viewer = new ImageViewer();
	}
	public void paint(Graphics g){
		g.drawImage(image, 0, 0, this);
	}
	class ExitWindow extends WindowAdapter{
		public void windowClosing(WindowEvent e){
			System.out.println("I܂");
			ImageViewer.this.setVisible(false);
			ImageViewer.this.dispose();
			System.exit(0);
		}
	}
}