import java.awt.Canvas;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;

@SuppressWarnings("serial")
public class ImageViewer2 extends JPanel{
	private JFrame frame;
	
	ImageViewer2(){
		JButton button = new JButton("Select File");
		add(button);
		button.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				JFileChooser chooser = new JFileChooser();
				int returnVal = chooser.showOpenDialog(frame);
				if(returnVal == JFileChooser.APPROVE_OPTION){
					String filename = chooser.getSelectedFile().getPath();
					@SuppressWarnings("unused")
					ImageViewer viewer = new ImageViewer(filename);
				}
			}
		});
	}
	public static void main(String[] args){
		JFrame frame = new JFrame("Image Viewer");
		frame.getContentPane().add(new ImageViewer2());
		frame.pack();
		frame.setVisible(true);
	}
	public class ImageViewer extends Frame{
		private int imgWidth, imgHeight;
		private Image image;
		
		ImageViewer(String filename){
			setImage(filename);
			DrawCanvas dc = new DrawCanvas();
			dc.setSize(imgWidth, imgHeight);
			add(dc);
			pack();
			setTitle(filename);
			setVisible(true);
			addWindowListener(new ExitWindow());
		}
		private void setImage(String filename){
			image = Toolkit.getDefaultToolkit().getImage(filename);
			MediaTracker mt = new MediaTracker(this);
			mt.addImage(image, 0);
			try{
				mt.waitForID(0);
			}catch(InterruptedException ex){
				throw new IllegalArgumentException("O");
			}
			imgWidth = image.getWidth(this);
			imgHeight = image.getHeight(this);
		}
		class ExitWindow extends WindowAdapter{
			public void windowClosing(WindowEvent e){
				System.out.println("摜܂");
				ImageViewer.this.setVisible(false);
				ImageViewer.this.dispose();
			}
		}
		class DrawCanvas extends Canvas{
			public void paint(Graphics g){
				g.drawImage(image, 0, 0, imgWidth, imgHeight, this);
			}
		}
	}
}