import java.awt.Canvas;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

@SuppressWarnings("serial")
public class ImageViewerCanvas extends Frame{
	private Image image;
	private int imgWidth, imgHeight;
	
	ImageViewerCanvas(){
		setImage();
		DrawCanvas dc = new DrawCanvas();
		dc.setSize(imgWidth, imgHeight);
		add(dc);
		setTitle("ÏXO");
		pack();
		setVisible(true);
		addWindowListener(new ExitWindow());
	}
	private void setImage(){
		image = Toolkit.getDefaultToolkit().getImage("simazu.jpg");
		MediaTracker mt = new MediaTracker(this);
		mt.addImage(image, 0);
		try{
			mt.waitForID(0);
		}catch(InterruptedException ex){
			throw new IllegalArgumentException("O");
		}
		imgWidth = image.getWidth(this);
		imgHeight = image.getHeight(this);
	}
	public static void main(String[] args){
		@SuppressWarnings("unused")
		ImageViewerCanvas viewer = new ImageViewerCanvas();
	}
	class DrawCanvas extends Canvas{
		public void paint(Graphics g){
			g.drawImage(image, 0, 0, imgWidth, imgHeight, this);
		}
	}
	class ExitWindow extends WindowAdapter{
		public void windowClosing(WindowEvent e){
			System.out.println("I܂");
			ImageViewerCanvas.this.setVisible(false);
			ImageViewerCanvas.this.dispose();
			System.exit(0);
		}
	}
}