import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class Network3{
	public static final int ECHO_PORT = 10007;
	
	public static void main(String[] args){
		ServerSocket serverSocket = null;
		Socket socket = null;
		
		try{
			serverSocket = new ServerSocket(ECHO_PORT);
			System.out.println("EchoServerN܂(port="+serverSocket.getLocalPort()+")");
			socket = serverSocket.accept();
			System.out.println("ڑ܂"+socket.getRemoteSocketAddress());
			BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
			PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
			String line;
			
			while((line = in.readLine()) != null){
				System.out.println("M:"+line);
				out.println(line);
				System.out.println("M:"+line);
			}
		}
		catch(IOException e){
			e.printStackTrace();
		}
		finally{
			try{
				if(socket != null){
					socket.close();
				}
			}
			catch(IOException e){
			}
			try{
				if(serverSocket != null)
					serverSocket.close();
			}
			catch(IOException e){
			}
		}
	}
}