import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class Network5{
	public static final int ECHO_PORT = 10007;
	
	public static void main(String[] args){
		ServerSocket serverSocket = null;
		
		try{
			serverSocket = new ServerSocket(ECHO_PORT);
			System.out.println("EchoServerN܂(port="+serverSocket.getLocalPort()+")");
			
			while(true){
				Socket socket = serverSocket.accept();
				new EchoThread01(socket).start();
			}
		}
		catch(IOException e){
			e.printStackTrace();
		}
		finally{
			try{
				if(serverSocket != null){
					serverSocket.close();
				}
			}
			catch(IOException e){
			}
		}
	}
}
class EchoThread01 extends Thread{
	private Socket socket;
	
	public EchoThread01(Socket socket){
		this.socket = socket;
		System.out.println("ڑ܂"+socket.getRemoteSocketAddress());
	}
	public void run(){
		try{
			BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
			PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
			String line;
			
			while((line = in.readLine()) != null){
				System.out.println(socket.getRemoteSocketAddress()+"M:"+line);
				out.println(line);
				System.out.println(socket.getRemoteSocketAddress()+"M:"+line);
			}
		}
		catch(IOException e){
			e.printStackTrace();
		}
		finally{
			try{
				if(socket != null){
					socket.close();
				}
			}
			catch(IOException e){
			}
			System.out.println("ؒf܂"+socket.getRemoteSocketAddress());
		}
	}
}