import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class Network5a{
	public static final int ECHO_PORT = 10007;
	
	public static void main(String[] args){
		ServerSocket serverSocket = null;
		
		try{
			serverSocket = new ServerSocket(ECHO_PORT);
			System.out.println("EchoServerN܂(port="+serverSocket.getLocalPort()+")");
			
			while(true){
				Socket socket = serverSocket.accept();
				new EchoThread02(socket).start();
			}
		}
		catch(IOException e){
			e.printStackTrace();
		}
		finally{
			try{
				if(serverSocket != null){
					serverSocket.close();
				}
			}
			catch(IOException e){
			}
		}
	}
}
class EchoThread02 extends Thread{
	private Socket socket;
	private static int n;
	
	public EchoThread02(Socket socket){
		this.socket = socket;
		System.out.println("ڑ܂"+socket.getRemoteSocketAddress());
		n++;
	}
	public void run(){
		try{
			BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
			PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
			String line;
			
			while((line = in.readLine()) != null){
				if(line.equals("n")){
					System.out.println(socket.getRemoteSocketAddress()+"M:"+line);
					out.println("݂̃NCAg"+n+"łB");
					System.out.println(socket.getRemoteSocketAddress()+"M:݂̃NCAg"+n+"łB");
				}
				else{
					System.out.println(socket.getRemoteSocketAddress()+"M:"+line);
					out.println(line);
					System.out.println(socket.getRemoteSocketAddress()+"M:"+line);
				}
			}
		}
		catch(IOException e){
			e.printStackTrace();
		}
		finally{
			try{
				if(socket != null){
					socket.close();
				}
			}
			catch(IOException e){
			}
			System.out.println("ؒf܂"+socket.getRemoteSocketAddress());
			n--;
		}
	}
}