import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;

public class Network6{
	public static final int PACKET_SIZE = 1024;
	
	public static void main(String[] args){
		int serverPort = 0;
		
		if(args.length != 1){
			System.out.println("|[gԍ̎w肪sł");
			System.exit(1);
		}
		else{
			try{
				serverPort = Integer.parseInt(args[0]);
			}
			catch(NumberFormatException e){
				System.out.println("|[gԍ̎w肪sł");
				System.exit(1);
			}
			if(serverPort < 1024 || serverPort >= 65536){
				System.out.println("|[gԍ̎w肪sł");
				System.exit(1);
			}
		}
		DatagramSocket socket = null;
		InetSocketAddress remoteAddress = new InetSocketAddress("localhost", serverPort);
		
		try{
			BufferedReader keyIn = new BufferedReader(new InputStreamReader(System.in));
			socket = new DatagramSocket();
			String message;
			
			while((message = keyIn.readLine()).length() > 0){
				byte[] buf = message.getBytes();
				DatagramPacket packet = new DatagramPacket(buf, buf.length, remoteAddress);
				socket.send(packet);
			}
		}
		catch(IOException e){
			e.printStackTrace();
		}
		finally{
			if(socket != null){
				socket.close();
			}
		}
	}
}