import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;

public class Network6a{
	public static final int PACKET_SIZE = 1024;
	
	public static void main(String[] args){
		int[] serverPort = {0, 1, 2};
		
		if(args.length != 3){
			System.out.println("|[gԍ̎w肪sł");
			System.exit(1);
		}
		else{
			try{
				for(int i = 0;i < 3;i++){
					serverPort[i] = Integer.parseInt(args[i]);
				}
			}
			catch(NumberFormatException e){
				System.out.println("|[gԍ̎w肪sł");
				System.exit(1);
			}
			for(int i = 0;i < 3;i++){
				if(serverPort[i] < 1024 || serverPort[i] >= 65536){
					System.out.println("|[gԍ̎w肪sł");
					System.exit(1);
				}
			}
		}
		DatagramSocket socket = null;
		InetSocketAddress remoteAddress[] = new InetSocketAddress[3];
		
		for(int i = 0;i < 3;i++){
			remoteAddress[i] = new InetSocketAddress("localhost", serverPort[i]);
		}
		try{
			BufferedReader keyIn = new BufferedReader(new InputStreamReader(System.in));
			socket = new DatagramSocket();
			String message;
			
			while((message = keyIn.readLine()).length() > 0){
				byte[] buf = message.getBytes();
				
				for(int i = 0;i < 3;i++){
					DatagramPacket packet = new DatagramPacket(buf, buf.length, remoteAddress[i]);
					socket.send(packet);
				}
			}
		}
		catch(IOException e){
			e.printStackTrace();
		}
		finally{
			if(socket != null){
				socket.close();
			}
		}
	}
}