import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class Network7{
	public static final int PACKET_SIZE = 1024;
	
	public static void main(String[] args){
		int serverPort = 0;
		
		if(args.length != 1){
			System.out.println("|[gԍ̎w肪sł");
			System.exit(1);
		}
		else{
			try{
				serverPort = Integer.parseInt(args[0]);
			}
			catch(NumberFormatException e){
				System.out.println("|[gԍ̎w肪sł");
				System.exit(1);
			}
			if(serverPort < 1024 || serverPort >= 65536){
				System.out.println("|[gԍ̎w肪sł");
				System.exit(1);
			}
		}
		DatagramSocket socket = null;
		byte[] buf = new byte[PACKET_SIZE];
		DatagramPacket packet = new DatagramPacket(buf, buf.length);
		
		try{
			socket = new DatagramSocket(serverPort);
			System.out.println("DatagramReceiverN܂(port="+socket.getLocalPort()+")");
			
			while(true){
				socket.receive(packet);
				String message = new String(buf, 0, packet.getLength());
				System.out.println(packet.getSocketAddress()+"M:"+message);
			}
		}
		catch(IOException e){
			e.printStackTrace();
		}
		finally{
			if(socket != null){
				socket.close();
			}
		}
	}
}